/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ChickenDropsCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation UID = new ResourceLocation("chickens", "chicken_drops");
    public static final Component TITLE = new TranslatableComponent("gui.drops");
    IGuiHelper guiHelper;

    public ChickenDropsCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("chickens", "textures/gui/drops.png"), 0, 0, 82, 54).addPadding(0, 20, 0, 0).build();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/drops_icon.png"), 0, 0, 16, 16);
    }

    @NotNull
    public ResourceLocation getUid() {
        return UID;
    }

    @NotNull
    public Class getRecipeClass() {
        return Recipe.class;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        list.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{recipe.input}));
        ingredients.setInputIngredients(list);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.output);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @NotNull Recipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 13, 15);
        guiItemStacks.init(1, false, 57, 15);
        guiItemStacks.set(ingredients);
    }

    public static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }
    }
}

